import time
from types import TracebackType


class Benchmark:
    def __enter__(self) -> None:
        self.start_time = time.monotonic_ns()
        return self

    def __exit__(
        self,
        exc_type: type[BaseException] | None,
        exc_val: BaseException | None,
        exc_tb: TracebackType | None,
    ) -> None:
        self.end_time = time.monotonic_ns()
        self.elapsed_time_ns = self.end_time - self.start_time

    @property
    def elapsed_time_ms(self) -> float:
        return self.elapsed_time_ns * 1e-6
