from defence360agent.application.determine_hosting_panel import (
    get_hosting_panel,
)
from defence360agent.contracts.config import ANTIVIRUS_MODE
from defence360agent.subsys.panels.base import AbstractPanel


panel = None


def HostingPanel(check_for_changes=False) -> AbstractPanel:
    """
    Set the panel if panel is not set or if it is set to defence360agent class
     in Imunify360.

     - the panel is stored in only one place - in this module (_panel)
     - if we are AV we always use AV panel classes
     - if we are Imunify360 we always use im360 panel classes
     :type check_for_changes: bool
    """
    global panel

    if panel is None or check_for_changes:
        panel = get_hosting_panel(
            "defence360agent" if ANTIVIRUS_MODE else "im360"
        )
    return panel
