import os


def _build_path(name):
    return os.path.join(os.sep, "proc", "sys", *name.split("."))


def read(name):
    with open(_build_path(name)) as f:
        data = f.read().strip()
        if data.isdigit:
            return int(data)
        else:
            return data


def write(name, value):
    with open(_build_path(name), "w") as f:
        f.write(str(value))
