from defence360agent.subsys.panels.base import PanelException
from defence360agent.subsys.panels.directadmin import DirectAdmin
from defence360agent.subsys.panels.hosting_panel import HostingPanel
from defence360agent.rpc_tools import ValidationError
from defence360agent.rpc_tools.lookup import RootEndpoints, bind


class HostingPanelEndpoints(RootEndpoints):
    @bind("enable-plugin")
    async def enable_plugin(self, plugin_name=None):
        return await self.hosting_panel.enable_imunify_plugin(plugin_name)

    @bind("disable-plugin")
    async def disable_plugin(self, plugin_name=None):
        return await self.hosting_panel.disable_imunify_plugin(plugin_name)

    @bind("add-sudouser")
    async def add_sudouser(self, user):
        hp = self.hosting_panel
        if not isinstance(hp, DirectAdmin):
            raise ValidationError("Feature available only for DirectAdmin")

        return await hp.add_sudouser(user)

    @bind("delete-sudouser")
    async def delete_sudouser(self, user):
        hp = self.hosting_panel
        if not isinstance(hp, DirectAdmin):
            raise ValidationError("Feature available only for DirectAdmin")

        return await hp.delete_sudouser(user)

    @bind("list-docroots")
    async def get_docroots(self):
        return {"items": await self.hosting_panel.list_docroots()}

    @property
    def hosting_panel(self):
        try:
            return HostingPanel()
        except PanelException as e:
            raise ValidationError(str(e))
