# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# https://cloudlinux.com/docs/LICENCE.TXT
#
from clcommon.lib import cledition

from clconfigure import task
from clconfigure.awp import enable_accelerate_wp_free
from clconfigure.cagefs import clean_cagefs_without_lve_environment

from . import shared
from ..clpro import trigger_manage_clplus


@task(f"Initial provisioning during transition of {cledition.get_cl_edition_readable()} into CloudLinux OS Shared Pro")
def preprovision(edition):
    """
    Triggered before jwt token change in rhn-client-tools
    but already after successful registration with new edition.

    Designed to safely terminate things that should not be
    running as part of current edition but avoid license checks.
    """
    clean_cagefs_without_lve_environment()


@task("Configuring environment for CloudLinux OS Shared PRO")
def provision(edition):
    """
    Converts "normal" CloudLinux Shared into CL Shared PRO.
    """
    # first convert to shared
    shared.provision(edition)

    # cannot do that in posttrans because awp may be not installed
    # cron will handle that later
    enable_accelerate_wp_free()

    # automatically install things like cmt
    trigger_manage_clplus()
