"""
RPC building blocks. Use the utils provided by this package whenever you
need to extend the RPC client/server functionality (i.e. add a new endpoint).
However, new endpoints should not be put in this package to avoid undesirable
interdependencies.
"""

from defence360agent.utils.cli import ERROR, SUCCESS, WARNING
from .exceptions import ResponseError, ServiceStateError, SocketError
from .lookup import Endpoints, UserType
from .utils import is_running
from .validate import ValidationError

__all__ = [
    "ERROR",
    "SUCCESS",
    "WARNING",
    "ResponseError",
    "ServiceStateError",
    "SocketError",
    "Endpoints",
    "UserType",
    "is_running",
    "ValidationError",
]
