from typing import Optional

from defence360agent.subsys.panels.base import PanelException
from defence360agent.utils import check_run, OsReleaseInfo
from defence360agent.subsys import web_server
from im360.subsys.panels.base import RemoteIPInterface

_INSTALL_YUM_CMD = ["yum", "-y", "install", "ea-apache24-mod_remoteip"]
# underscore to dash
_INSTALL_APT_CMD = ["apt", "-y", "install", "ea-apache24-mod-remoteip"]
_NOT_SUPPORTED = "mod_remoteip is supported with EasyApache 4 only"


class RemoteIP(RemoteIPInterface):
    async def remoteip_activated(self) -> bool:
        return await self._is_loaded_to_apache()

    async def remoteip_install(self) -> Optional[str]:  # type: ignore
        if not web_server.is_EA4_available():
            raise PanelException(_NOT_SUPPORTED)
        if OsReleaseInfo.id_like() & OsReleaseInfo.DEBIAN:
            await check_run(_INSTALL_APT_CMD)
        else:
            await check_run(_INSTALL_YUM_CMD)
