from typing import Set

from defence360agent.subsys.panels.plesk.api import get_admin_emails
from defence360agent.subsys.panels.plesk import Plesk as Base

from ..base import PanelInterface
from .mod_security import PleskModSecurity
from .remoteip import RemoteIP


class Plesk(Base, PanelInterface, PleskModSecurity, RemoteIP):
    pure_ftp_conf_cls = None

    def http_ports(self) -> Set[int]:
        return {8880}  # Administrative interface of Plesk over HTTP

    def https_ports(self) -> Set[int]:
        return {8443}  # Administrative interface of Plesk over HTTPS

    async def _get_all_admin_emails(self):
        return await get_admin_emails()

    def remoteip_supported(self) -> bool:
        return True
