# -*- coding: utf-8 -*-
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#
from .helpers import hook_method

__author__ = "Aleksandr Shyshatsky"


class ModifyUserHook:
    """
    This hook provides bunch of events related
    to user manipulations like create, rename, transit, etc.
    """
    HOOK_VERSION = 1

    @hook_method
    def post_create_user(self, username, owner, **kwargs):
        """
        Triggered after creating new user.
        :param username: account name
        :param owner: vendor's name
        """
        pass

    @hook_method
    def post_restore_user(self, username, **kwargs):
        """
        Triggered after creating new user.
        :param username: account name
        """
        pass

    @hook_method
    def pre_modify_user(self, username, new_name=None, new_owner=None, **kwargs):
        """
        Triggered before any modifications made to user
        :param username: account name
        :param new_name: new user account name
        :param new_owner: new owner after relocate
        """
        pass

    @hook_method
    def post_modify_user(self, username, new_name=None, new_owner=None, **kwargs):
        """
        Triggered after any modifications made to user
        :param username: account name
        :param new_name: new user account name
        :param new_owner: new owner after relocate
        """
        pass

    @hook_method
    def pre_delete_user(self, username, **kwargs):
        """
        Triggered before deleting user.
        :param username: account name
        """
        pass

    @hook_method
    def post_delete_user(self, username, **kwargs):
        """
        Triggered after deleting user.
        :param username: account name
        """
        pass
