"""Add unique composite index to wordpress_incident table for deduplication.

This migration adds a unique index on the fields used to identify duplicate
incidents (abuser, name, plugin, rule, severity, domain), similar to the
aggregation key used in the resident agent's aggregate plugin.
"""


def migrate(migrator, database, fake=False, **kwargs):
    """Add unique composite index for incident deduplication."""
    WordpressIncident = migrator.orm["wordpress_incident"]

    # Create unique index on the aggregate key fields
    # This allows ON CONFLICT handling for incident deduplication
    migrator.add_index(
        WordpressIncident,
        "abuser",
        "name",
        "plugin",
        "rule",
        "severity",
        "domain",
        unique=True,
    )


def rollback(migrator, database, fake=False, **kwargs):
    """Remove the unique composite index."""
    WordpressIncident = migrator.orm["wordpress_incident"]

    migrator.drop_index(
        WordpressIncident,
        "abuser",
        "name",
        "plugin",
        "rule",
        "severity",
        "domain",
    )
