import peewee as pw


class SecureSite(pw.Model):
    class Meta:
        db_table = "secure_site"

    user = pw.CharField(unique=True)
    subscription_type = pw.TextField(
        null=False,
        constraints=[pw.Check("subscription_type in ('basic','pro')")],
        default="basic",
    )


def migrate(migrator, _db, fake=False, **__):
    if fake:
        return

    migrator.create_model(SecureSite)


def rollback(*_, **__):
    """Not supported"""
