from peewee import CharField


def migrate(migrator, *_, fake=False, **__):
    if fake:
        return

    malware_scans = migrator.orm["malware_scans"]
    migrator.add_fields(
        malware_scans,
        initiator=CharField(null=True),
    )


def rollback(migrator, *_, fake=False, **__):
    if fake:
        return

    malware_scans = migrator.orm["malware_scans"]
    migrator.remove_fields(malware_scans, "initiator")
