"""
Drop constrains for icontact_throttle.message_type, since correlation server
can set any type (DEF-19971).
"""
from peewee import CharField, IntegerField, Model


class IContactThrottle(Model):
    class Meta:
        db_table = "icontact_throttle"

    message_type = CharField(primary_key=True)
    #: The last time we sent a notification about :attr:`message_type`
    timestamp = IntegerField(default=0)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return
    migrator.sql(
        "ALTER TABLE icontact_throttle RENAME TO icontact_throttle_old"
    )
    migrator.create_model(IContactThrottle)
    migrator.sql(
        "INSERT INTO icontact_throttle(message_type,timestamp) "
        "SELECT message_type,timestamp FROM icontact_throttle_old"
    )
    migrator.sql("DROP TABLE icontact_throttle_old")


def rollback(migrator, database, fake=False, **kwargs):
    pass
