import time

from defence360agent.contracts.config import IContactMessageType


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return
    IContactThrotle = migrator.orm["icontact_throttle"]
    IContactThrotle.create(
        message_type=IContactMessageType.SCAN_NOT_SCHEDULED,
        timestamp=time.time() + (7 * 86400),
    )


def rollback(migrator, database, fake=False, **kwargs):
    if fake:
        return
    IContactThrottle = migrator.orm["icontact_throttle"]
    IContactThrottle.delete().where(
        IContactThrottle.message_type == IContactMessageType.SCAN_NOT_SCHEDULED
    ).execute()
