import logging

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    IPList = migrator.orm["iplist"]
    captcha_pass_condition = (
        (IPList.listname == "WHITE")
        & (~IPList.full_access)
        & (~IPList.manual)
        & (IPList.comment.contains("due to successful captcha pass"))
    )
    try:
        q = IPList.update({IPList.captcha_passed: True}).where(
            captcha_pass_condition
        )
        q.execute()
    except Exception:
        logger.exception("Failed update to captcha_passed field")


def rollback(migrator, database, fake=False, **kwargs):
    pass
