import logging

from defence360agent.contracts.config import ConfigFile

logger = logging.getLogger(__name__)


def _update_config(path=None):
    config = {
        "MALWARE_SCAN_INTENSITY": {
            "ram": 2048,
        }
    }

    try:
        config_file = ConfigFile(path=path)
        config_file.dict_to_config(config)
    except Exception:
        logger.exception("Failed to set malware scan schedule config")


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    _update_config()


def rollback(migrator, database, fake=False, **kwargs):
    pass
