from defence360agent.contracts.config import ConfigFile


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return
    config_file = ConfigFile()
    conf = config_file.config_to_dict()
    if not conf:
        return

    malware_cleanup = conf.setdefault("MALWARE_CLEANUP", {})
    malware_cleanup.setdefault("trim_file_instead_of_removal", True)
    malware_cleanup.setdefault("keep_original_files_days", 14)

    config_file.dict_to_config(conf, validate=False)


def rollback(migrator, database, fake=False, **kwargs):
    pass
