import os
import logging

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return
    try:
        from im360.subsys import csf
        from im360.utils.net import IN, OUT, TCP
    except ImportError:
        pass
    else:
        if not os.path.isfile(csf.CSF_CONFIG):
            return
        try:
            csf.remove_ports(
                TCP,
                IN,
                44445,
                55556,
                6109,
                25001,
                445,
                5060,
                ranges={(7770, 7800)},
            )
            csf.remove_ports(TCP, OUT, 6109, 25001, 445, 5060)

        except Exception:
            logger.exception(
                "Failed to remove unused Arconis ports from csf config"
            )


def rollback(migrator, database, fake=False, **kwargs):
    pass
