import os
import logging

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return
    try:
        from im360.subsys import csf
        from im360.utils.net import IN, TCP
    except ImportError:
        pass
    else:
        if not os.path.isfile(csf.CSF_CONFIG):
            return
        try:
            csf.remove_ports(TCP, IN, 52223, 52224, 52225, 52226)
        except Exception:
            logger.exception("Failed to remove captcha ports from csf config")


def rollback(migrator, database, fake=False, **kwargs):
    pass
