import logging
import shutil
import gzip
import os

from defence360agent.contracts.config import Logger
from defence360agent.internals.logger import get_log_file_names

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    for filename in get_log_file_names():
        for i in range(1, Logger.BACKUP_COUNT + 1):
            source = f"{filename}.{i}"
            dest = f"{source}.gz"
            try:
                if os.path.exists(source):
                    with open(source, "rb") as f_in, gzip.open(
                        dest, "wb"
                    ) as f_out:
                        shutil.copyfileobj(f_in, f_out)
                    os.remove(source)
            except Exception as e:
                logger.exception(
                    "Failed file %s compression with %s", source, e
                )


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
