import peewee as pw


def migrate(migrator, database, fake=False, **kwargs):
    Country = migrator.orm["country"]

    class Proactive(pw.Model):
        class Meta:
            db_table = "proactive"

        id = pw.PrimaryKeyField()
        timestamp = pw.IntegerField(null=False)
        ip = pw.TextField(null=True)
        ip_int = pw.IntegerField(null=True)
        ip_version = pw.IntegerField(null=True)
        ip_country = pw.ForeignKeyField(Country, null=True)
        reason = pw.TextField(null=False)
        description = pw.TextField(null=True)
        action = pw.TextField(null=False)
        host = pw.TextField(null=True)
        path = pw.TextField(null=False)
        url = pw.TextField(null=True)
        count = pw.IntegerField(null=False)
        uid = pw.IntegerField(null=False)
        gid = pw.IntegerField(null=False)

    class ProactiveEnv(pw.Model):
        event = pw.ForeignKeyField(
            Proactive, null=False, on_delete="CASCADE", related_name="env"
        )
        name = pw.TextField(null=False)
        value = pw.TextField(null=True)

        class Meta:
            db_table = "proactive_env"
            primary_key = pw.CompositeKey("event", "name", "value")

    migrator.create_model(Proactive)
    migrator.create_model(ProactiveEnv)


def rollback(migrator, database, fake=False, **kwargs):
    ProactiveEnv = migrator.orm["proactive_env"]
    Proactive = migrator.orm["proactive"]
    migrator.remove_model(ProactiveEnv)
    migrator.remove_model(Proactive)
