"""
Altering MalwareScan.type in order to add ability to support
'malware-response' scan type
"""
import peewee as pw


def migrate(migrator, database, fake=False, **kwargs):
    MalwareScan = migrator.orm["malware_scans"]

    MalwareScan.update(type="realtime").where(
        MalwareScan.type == "inotify"
    ).execute()

    migrator.change_fields(
        MalwareScan, path=pw.CharField(null=True, default="")
    )
    migrator.change_fields(
        MalwareScan,
        type=pw.CharField(
            null=False,
            constraints=[
                pw.Check(
                    "type in ('on-demand', 'realtime', 'malware-response')"
                )
            ],
        ),
    )


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
