def migrate(migrator, database, fake=False, **kwargs):
    """Recreating DB in order to make `name` as primary key"""
    migrator.sql(
        """
      CREATE TABLE "last_synclist_new" (
        "timestamp" REAL,
        "name" VARCHAR(255) NOT NULL PRIMARY KEY
        )"""
    )
    migrator.sql(
        "INSERT INTO last_synclist_new "
        'SELECT timestamp, "ip" AS name FROM last_synclist LIMIT 1'
    )
    migrator.sql("DROP TABLE last_synclist")
    migrator.sql("ALTER TABLE last_synclist_new RENAME TO last_synclist")


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
