import logging

import peewee as pw


logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    class WhitelistedCrawler(pw.Model):
        class Meta:
            db_table = "whitelisted_crawlers"

        id = pw.PrimaryKeyField()
        description = pw.TextField(null=False)

    class WhitelistedCrawlerDomain(pw.Model):
        class Meta:
            db_table = "whitelisted_crawler_domains"

        id = pw.PrimaryKeyField()
        crawler = pw.ForeignKeyField(
            WhitelistedCrawler,
            null=False,
            on_delete="CASCADE",
            related_name="domains",
        )
        domain = pw.TextField(null=False)

    migrator.create_model(WhitelistedCrawler)
    migrator.create_model(WhitelistedCrawlerDomain)


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    migrator.remove_model(migrator.orm["whitelisted_crawlers"])
    migrator.remove_model(migrator.orm["whitelisted_crawler_domains"])
