import json
import logging
from contextlib import suppress

logger = logging.getLogger(__name__)


class VirusdieLicense:
    CONFIG_FILE = "/usr/local/vdserver/config.json"

    def unregister(self):
        self._write_key("")

    def _write_key(self, key):
        with open(self.CONFIG_FILE) as read_file:
            content = json.load(read_file)

        content["vdbApiKey"] = key

        with open(self.CONFIG_FILE, "w") as write_file:
            json.dump(
                content,
                write_file,
                sort_keys=True,
                indent=2,
                separators=(",", ": "),
            )


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    with suppress(FileNotFoundError):
        VirusdieLicense().unregister()


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
