import glob
import os
import tempfile


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    tmp_dir = tempfile.gettempdir()

    # fix bugs of 2.1 version
    path = os.path.join(tmp_dir, "predict_model_description.json")
    if os.path.isfile(path):
        os.remove(path)

    # fix bugs of 2.2 version
    pattern = os.path.join(tmp_dir, "imunify360*")
    for filename in glob.glob(pattern):
        if os.path.isfile(filename):
            os.remove(filename)


def rollback(migrator, database, fake=False, **kwargs):
    pass
