from peewee import CharField, Model, IntegerField, CompositeKey


class IPListRecord(Model):
    network_address = IntegerField(null=False)
    netmask = IntegerField(null=False)
    version = IntegerField(null=False)
    iplist_id = IntegerField(null=False)

    class Meta:
        db_table = "iplistrecord"
        primary_key = CompositeKey(
            "network_address", "netmask", "version", "iplist_id"
        )


class IPListPurpose(Model):
    purpose = CharField(null=False)
    iplist_id = IntegerField(null=False)

    class Meta:
        db_table = "iplistpurpose"
        primary_key = CompositeKey("purpose", "iplist_id")


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(IPListRecord)
    migrator.create_model(IPListPurpose)


def rollback(migrator, database, fake=False, **kwargs):
    IPListRecord = migrator.orm["iplistrecord"]
    migrator.remove_model(IPListRecord)
    IPListPurpose = migrator.orm["iplistpurpose"]
    migrator.remove_model(IPListPurpose)
