import logging

from defence360agent.contracts.config import IConfig, ConfigFile

logger = logging.getLogger(__name__)


def migrate(
    migrator,
    database,
    fake=False,
    config_file: IConfig = ConfigFile(),
    **kwargs
):
    if fake:
        return

    try:
        config = config_file.config_to_dict(normalize=False)

        if "MALWARE_SCANNING" not in config:
            return

        config["MALWARE_SCANNING"].pop("i360_clamd", None)
        config["MALWARE_SCANNING"].pop("show_clamav_results", None)
        config["MALWARE_SCANNING"].pop("clamav_binary", None)

        config_file.dict_to_config(config, overwrite=True, validate=False)
    except Exception:
        logger.exception("Failed to remove clamav config options")


def rollback(migrator, database, fake=False, **kwargs):
    pass
