import logging

import peewee as pw


logger = logging.getLogger(__name__)

SCOPE_LOCAL, SCOPE_GROUP = "local", "group"


def migrate(migrator, database, fake=False, **kwargs):
    ip_list = migrator.orm["iplist"]
    migrator.add_fields(
        ip_list,
        scope=pw.CharField(
            null=True,
            constraints=[
                pw.Check("scope in ('%s','%s')" % (SCOPE_LOCAL, SCOPE_GROUP))
            ],
        ),
    )


def rollback(migrator, database, fake=False, **kwargs):
    ip_list = migrator.orm["iplist"]
    migrator.remove_fields(ip_list, "scope")
