import peewee as pw


def migrate(migrator, database, fake=False, **kwargs):
    class RemoteProxyGroup(pw.Model):
        """Groups multiple remote proxies together with common data."""

        MANUAL = "manual"
        IMUNIFY360 = "imunify360"
        name = pw.CharField(null=False)
        source = pw.CharField(
            null=False,
            constraints=[
                pw.Check("source in ('{}', '{}')".format(MANUAL, IMUNIFY360))
            ],
        )
        enabled = pw.BooleanField(null=False, default=True)

        class Meta:
            db_table = "remote_proxy_group"
            indexes = ((("name", "source"), True),)

    class RemoteProxy(pw.Model):
        group = pw.ForeignKeyField(RemoteProxyGroup, null=False)
        network = pw.TextField(null=False)

        class Meta:
            db_table = "remote_proxy"

    migrator.create_model(RemoteProxyGroup)
    migrator.create_model(RemoteProxy)


def rollback(migrator, database, fake=False, **kwargs):
    RemoteProxy = migrator.orm["remote_proxy"]
    RemoteProxyGroup = migrator.orm["remote_proxy_group"]
    migrator.remove_model(RemoteProxy)
    migrator.remove_model(RemoteProxyGroup)
