import logging

import peewee as pw

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""
    IPList = migrator.orm["iplist"]
    migrator.add_fields(
        IPList,
        no_captcha=pw.BooleanField(null=False, default=False),
    )
    migrator.sql(
        "UPDATE iplist SET no_captcha=1 "
        "WHERE listname='GRAY' AND dos_expiration"
    )
    migrator.remove_fields(IPList, "dos_expiration")


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
