from time import time

import peewee as pw

from defence360agent.model.simplification import FilenameField


class MalwareHistory(pw.Model):
    class Meta:
        db_table = "malware_history"

    path = FilenameField(null=False)
    event = pw.CharField(null=False)
    initiator = pw.CharField(null=False)
    cause = pw.CharField(null=False)
    file_owner = pw.CharField(null=True)
    ctime = pw.IntegerField(null=True, default=lambda: int(time()))


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(MalwareHistory)


def rollback(migrator, database, fake=False, **kwargs):
    MalwareHistory = migrator.orm["malware_history"]
    migrator.remove_model(MalwareHistory)
