import peewee as pw


class Eula(pw.Model):
    class Meta:
        db_table = "eula"

    updated = pw.DateField(primary_key=True)
    accepted = pw.IntegerField(null=True, default=None)


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(Eula)


def rollback(migrator, database, fake=False, **kwargs):
    Eula = migrator.orm["eula"]
    migrator.remove_model(Eula)
