"""
Migrate backup config from user oriented config file
to the separate internal file
"""
import os
from typing import Optional

from defence360agent.contracts.config import (
    BackupConfig,
    IConfig,
    IConfigFile,
    LocalConfig,
)
from defence360agent.utils import antivirus_mode


@antivirus_mode.skip
def migrate(
    migrator,
    database,
    fake=False,
    config_file: IConfig = LocalConfig(),
    backup_config_file: Optional[IConfigFile] = None,
    **kwargs,
):
    if fake:
        return
    if backup_config_file is None:
        backup_config_file = BackupConfig()

    if not (config_from := config_file.config_to_dict()):
        return

    # Do not overwrite existing config file
    if os.path.exists(backup_config_file.path):
        return
    backup_conf_current = config_from.get("BACKUP_RESTORE", {})
    config_to = {
        "BACKUP_SYSTEM": {
            "enabled": backup_conf_current.pop("enabled", False),
            "backup_system": backup_conf_current.pop("backup_system", None),
        }
    }
    backup_config_file.dict_to_config(
        config_to, overwrite=True, validate=False
    )
    config_file.dict_to_config(config_from, overwrite=True, validate=False)


@antivirus_mode.skip
def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
