from time import time

from peewee import BooleanField, IntegerField


def migrate(migrator, database, fake=False, **kwargs):
    MalwareHits = migrator.orm["malware_hits"]
    migrator.add_fields(
        MalwareHits, malicious=BooleanField(null=False, default=False)
    )
    MalwareIgnorePath = migrator.orm["malware_ignore_path"]
    migrator.add_fields(
        MalwareIgnorePath,
        added_date=IntegerField(null=False, default=lambda: int(time())),
    )


def rollback(migrator, database, fake=False, **kwargs):
    MalwareHits = migrator.orm["malware_hits"]
    migrator.remove_fields(MalwareHits, "malicious")

    MalwareIgnorePath = migrator.orm["malware_ignore_path"]
    migrator.remove_fields(MalwareIgnorePath, "added_date")
