"""
Filling `auto_whitelisted` filed that was added in previous 049 migration.
Matching IPs that were auto added earlier.
"""


def migrate(migrator, database, fake=False, **kwargs):
    IPList = migrator.orm["iplist"]
    # mark previously autowhitelisted
    IPList.update(auto_whitelisted=True).where(
        IPList.comment.startswith("IP auto-whitelisted with")
    ).execute()


def rollback(migrator, database, fake=False, **kwargs):
    pass
