import logging

import peewee as pw


logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    MalwareHits = migrator.orm["malware_hits"]
    migrator.add_fields(
        MalwareHits, vendor=pw.CharField(null=False, default="clamav")
    )


def rollback(migrator, database, fake=False, **kwargs):
    MalwareHits = migrator.orm["malware_hits"]
    migrator.remove_fields(MalwareHits, "vendor")
