import json

from playhouse.shortcuts import model_to_dict

FALLBACK_LICENSE_FILE = "/var/imunify360/license_old.json"


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return
    LicenseModel = migrator.orm["license"]
    lic, _ = LicenseModel.get_or_create(
        defaults={
            "status": True,
            "expiration": 0,
        }
    )
    with open(FALLBACK_LICENSE_FILE, "w") as f:
        json.dump(model_to_dict(lic), f)
    migrator.remove_model(LicenseModel)


def rollback(migrator, database, fake=False, **kwargs):
    pass
