import logging
import subprocess

from defence360agent.utils import antivirus_mode

logger = logging.getLogger(__name__)


@antivirus_mode.skip
def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return
    from im360.subsys.panels.cpanel import cPanel

    if cPanel.is_installed():
        try:
            subprocess.run(["/scripts/rebuildinstalledssldb"])
        except Exception as e:
            logger.warning("Failed to rebuild cpanel ssl db: %s", str(e))


@antivirus_mode.skip
def rollback(migrator, database, fake=False, **kwargs):
    pass
