from logging import getLogger

from defence360agent.utils import run_coro
from defence360agent.utils import antivirus_mode

logger = getLogger(__name__)


@antivirus_mode.skip
def migrate(migrator, database, fake=False, **kwargs):
    try:
        from im360.subsys.panels.plesk import Plesk
        from im360.subsys.panels.plesk.mod_security import ModSecSettings

        if (
            fake
            or not Plesk.is_installed()
            or not run_coro(Plesk.installed_modsec())
        ):
            return
        ModSecSettings.include_modsec_conf()

        from defence360agent.subsys.web_server import graceful_restart_sync

        graceful_restart_sync()
    except Exception as e:
        logger.warning("Error during web-server update: %s", str(e))


@antivirus_mode.skip
def rollback(migrator, database, fake=False, **kwargs):
    try:
        from im360.subsys.panels.plesk import Plesk
        from im360.subsys.panels.plesk.mod_security import ModSecSettings

        if (
            fake
            or not Plesk.is_installed()
            or not run_coro(Plesk.installed_modsec())
        ):
            return
        ModSecSettings.revert_conf_include()

        from defence360agent.subsys.web_server import graceful_restart_sync

        graceful_restart_sync()
    except Exception as e:
        logger.warning("Error during web-server update: %s", str(e))
