import peewee as pw


class License(pw.Model):
    class Meta:
        db_table = "license"

    status = pw.BooleanField(primary_key=True)
    expiration = pw.IntegerField(null=False, default=0)
    limit = pw.IntegerField(null=True)
    redirect_url = pw.CharField(null=True)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""
    migrator.create_model(License)


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    License = migrator.orm["license"]
    migrator.drop_model(License)
