"""Peewee migrations: ::

    > Model = migrator.orm['name']

    > migrator.sql(sql)
    > migrator.python(func, *args, **kwargs)
    > migrator.create_model(Model)
    > migrator.remove_model(Model, cascade=True)
    > migrator.add_fields(Model, **fields)
    > migrator.change_fields(Model, **fields)
    > migrator.remove_fields(Model, *field_names, cascade=True)
    > migrator.rename_field(Model, old_field_name, new_field_name)
    > migrator.rename_table(Model, new_table_name)
    > migrator.add_index(Model, *col_names, unique=False)
    > migrator.drop_index(Model, *col_names)
    > migrator.add_not_null(Model, *field_names)
    > migrator.drop_not_null(Model, *field_names)
    > migrator.add_default(Model, field_name, default)

"""
import peewee as pw


class Incident(pw.Model):
    id = pw.IntegerField(primary_key=True, null=True)
    plugin = pw.CharField(null=True)
    rule = pw.CharField(null=True)
    timestamp = pw.FloatField(null=True)
    retries = pw.IntegerField(null=True)
    severity = pw.IntegerField(null=True)
    name = pw.CharField(null=True)
    description = pw.CharField(null=True)
    abuser = pw.CharField(null=True)

    class Meta:
        db_table = "incident"


class IPList(pw.Model):
    ip = pw.CharField(primary_key=True, null=False)
    listname = pw.CharField(
        null=False,
        constraints=[pw.Check("listname in ('WHITE','BLACK','GRAY')")],
    )
    expiration = pw.IntegerField(default=0, null=True)

    class Meta:
        db_table = "iplist"


class BlocklistHistory(pw.Model):
    id = pw.IntegerField(primary_key=True, null=True)
    plugin = pw.CharField(null=True)
    rule = pw.CharField(null=True)
    timestamp = pw.FloatField(null=True)
    ip = pw.CharField(null=True)

    class Meta:
        db_table = "blocklist_history"


class LastSynclist(pw.Model):
    timestamp = pw.FloatField(primary_key=True, null=True)

    class Meta:
        db_table = "last_synclist"


def migrate(migrator, database, fake=False, **kwargs):
    """In memory of former create_db() (RIP)"""

    migrator.create_model(Incident)
    migrator.create_model(IPList)
    migrator.create_model(BlocklistHistory)
    migrator.create_model(LastSynclist)


def rollback(migrator, database, fake=False, **kwargs):
    """Nothing to rollback."""
