"""Remove sent_to_server column from wordpress_incident table.

The sent_to_server field is no longer needed for WordPress incident tracking.
"""

import peewee as pw


def migrate(migrator, database, fake=False, **kwargs):
    WordpressIncident = migrator.orm["wordpress_incident"]
    migrator.remove_fields(WordpressIncident, "sent_to_server")


def rollback(migrator, database, fake=False, **kwargs):
    WordpressIncident = migrator.orm["wordpress_incident"]
    migrator.add_fields(
        WordpressIncident,
        sent_to_server=pw.BooleanField(null=False, default=False),
    )
