"""Create wordpress_incident table for WordPress CVE protection incidents.

This migration creates a dedicated table for WordPress incidents rather than
using the generic incident table. This allows for better separation of concerns
and cleaner data model.
"""

import peewee as pw
from playhouse.sqlite_ext import JSONField


class WordpressIncident(pw.Model):
    id = pw.IntegerField(primary_key=True, null=True)
    plugin = pw.CharField(null=True)
    rule = pw.CharField(null=True)
    timestamp = pw.FloatField(null=True)
    retries = pw.IntegerField(null=True)
    severity = pw.IntegerField(null=True)
    name = pw.CharField(null=True)
    description = pw.TextField(null=True)
    abuser = pw.CharField(null=True)
    country = pw.CharField(null=True, column_name="country_id")
    domain = pw.TextField(null=True, default=None)
    extra_info = JSONField(null=True)
    sent_to_server = pw.BooleanField(null=False, default=False)

    class Meta:
        db_table = "wordpress_incident"


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(WordpressIncident)

    # Add index on timestamp for performance
    migrator.add_index(WordpressIncident, "timestamp", unique=False)


def rollback(migrator, database, fake=False, **kwargs):
    migrator.remove_model(WordpressIncident, cascade=True)
