from peewee import FloatField, Model, BlobField


class MessageToSend(Model):
    class Meta:
        db_table = "messages_to_send_nr"

    timestamp = FloatField(null=False)
    message = BlobField(null=False)


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(MessageToSend)


def rollback(migrator, database, fake=False, **kwargs):
    MessageToSend = migrator.orm["messages_to_send"]
    migrator.drop_model(MessageToSend)
