"""Unmount sigs/v1 from CageFS."""
import logging
import subprocess
from pathlib import Path

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):  # NOSONAR python:S1142
    if fake:
        return

    try:
        from defence360agent.subsys import clcagefs

        filename = clcagefs.CAGEFS_MP_FILENAME
    except ImportError:
        filename = "/etc/cagefs/cagefs.mp"

    try:
        text = Path(filename).read_text()
    except FileNotFoundError:  # indication of a non-cagefs system
        return  # nothing to do
    except Exception as e:  # NOSONAR pylint:W0703
        logger.exception("Can't read %s, reason: %s", filename, e)
        return
    else:
        if "/var/imunify360/files/sigs/v1" not in text:
            return  # nothing to do

    try:
        subprocess.check_call(
            r"sed -i.im360-bak '\:/var/imunify360/files/sigs/v1:d' %s"
            " && grep /var/imunify360/files/sigs/v1 /proc/mounts"
            " | awk '{ print $2 }' | xargs -rn1 umount"
            " && /usr/sbin/cagefsctl --wait-lock --unmount-all"
            " && /usr/sbin/cagefsctl --wait-lock --force-update-etc"
            " && /usr/sbin/cagefsctl --wait-lock --remount-all" % (filename,),
            shell=True,
            executable="/bin/bash",
        )
    except Exception as e:  # NOSONAR pylint:W0703
        logger.exception("Can't unmount sigs/v1, reason: %s", e)


def rollback(migrator, database, fake=False, **kwargs):
    pass
