"""
Remove all default values from main config
(/etc/sysconfig/imunify360/imunify360.config).
See DEF-17214 for details.
"""
import logging

from defence360agent.contracts.config import LocalConfig
from defence360agent.contracts.config_provider import exclude_equals

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    try:
        local_config = LocalConfig()
        local_conf = local_config.config_to_dict(force_read=True)

        defaults = local_config.normalize({}, without_defaults=False)

        non_default_conf = exclude_equals(
            main_conf=local_conf, base_conf=defaults
        )
        local_config.dict_to_config(non_default_conf, overwrite=True)
    except Exception as exc:
        logger.error("Can't overwrite local config, reason: %s", exc)


def rollback(migrator, database, fake=False, **kwargs):
    pass
