import logging
import os

from defence360agent.contracts.config import ConfigFile, IConfig
from defence360agent.utils import log_error_and_ignore

logger = logging.getLogger(__name__)


def migrate(
    migrator,
    database,
    user_config_dir="/etc/imunify360/user_config",
    config_file: IConfig = ConfigFile(),
    fake=False,
    **kwargs
):
    if fake:
        return

    # Migrate root config
    migrate_config(config_file)

    if not os.path.exists(user_config_dir):
        return

    # Migrate user configs
    for username in os.listdir(user_config_dir):
        migrate_config(ConfigFile(username=username))


@log_error_and_ignore()
def migrate_config(config_file: IConfig):
    config = config_file.config_to_dict(normalize=False)
    if not config:
        return
    malware_settings = config.setdefault("MALWARE_SCANNING", {})

    default_action = malware_settings.get("default_action")
    if default_action == "quarantine":
        malware_settings["default_action"] = "cleanup"
        cleanup_settings = config.setdefault("MALWARE_CLEANUP", {})
        keep_original_files = cleanup_settings.get("keep_original_files_days")
        if keep_original_files is not None and keep_original_files < 180:
            cleanup_settings["keep_original_files_days"] = 180
    elif default_action in ("cleanup_or_quarantine", "delete"):
        malware_settings["default_action"] = "cleanup"
    else:
        return

    config_file.dict_to_config(
        config, overwrite=True, validate=False, normalize=False
    )


def rollback(migrator, database, fake=False, **kwargs):
    pass
