import peewee as pw

from defence360agent.feature_management.constants import NA, FULL, AV_REPORT


def migrate(migrator, database, fake=False, **kwargs):
    permissions_model = migrator.orm["feature_management_permissions"]
    migrator.add_fields(
        permissions_model,
        proactive_new=pw.TextField(
            default=FULL,
            null=False,
            constraints=[
                pw.Check("proactive_new in ('{}','{}')".format(NA, FULL))
            ],
        ),
        av=pw.TextField(
            default=AV_REPORT,
            null=False,
            constraints=[
                pw.Check("av in ('{}','{}','{}')".format(NA, AV_REPORT, FULL))
            ],
        ),
    )

    migrator.sql(
        "UPDATE feature_management_permissions SET av=? WHERE cleanup=1",
        (FULL,),
    )
    migrator.sql(
        "UPDATE feature_management_permissions SET av=? WHERE cleanup=0",
        (AV_REPORT,),
    )

    migrator.sql(
        "UPDATE feature_management_permissions SET proactive_new=? "
        "WHERE proactive=1",
        (FULL,),
    )
    migrator.sql(
        "UPDATE feature_management_permissions SET proactive_new=? "
        "WHERE proactive=0",
        (NA,),
    )

    migrator.remove_fields(permissions_model, "cleanup", "proactive")


def rollback(migrator, database, fake=False, **kwargs):
    pass
