import peewee as pw


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    class IgnoreListNew(pw.Model):
        ip = pw.CharField(null=False)
        network_address = pw.IntegerField(null=False)
        netmask = pw.IntegerField(null=False)
        version = pw.IntegerField(null=False)

        class Meta:
            db_table = "ignore_list_new"
            primary_key = pw.CompositeKey(
                "network_address", "netmask", "version"
            )

    migrator.create_model(IgnoreListNew)


def rollback(migrator, database, fake=False, **kwargs):
    pass
